#include <iostream>
#include <string>
#include <algorithm>

enum BloodType{
    O = 0,
    A = 1,
    B = 2,
    AB = 3
};

struct pacient{
    BloodType bt;
    int units_req;
    int origin;
};

bool compare(pacient p1, pacient p2){
    return p1.bt < p2.bt;
}

int n;
int available_O, available_A, available_B, available_AB;
pacient pacients[10000];

int result[10000][4];

int main(){
    std::ios::sync_with_stdio(false);
    std::cin.tie(0);
    std::cout.tie(0);
    std::cerr.tie(0);

    std::cin >> n;
    std::cin >> available_O >> available_A >> available_B >> available_AB;

    std::string type;
    int amount;
    for(int i=0;i<n;++i){
        std::cin >> type >> amount;
        if(type == "O"){
            pacients[i].bt = BloodType::O;
        }else if(type == "A"){
            pacients[i].bt = BloodType::A;
        }else if(type == "B"){
            pacients[i].bt = BloodType::B;
        }else{
            pacients[i].bt = BloodType::AB;
        }
        pacients[i].units_req = amount;
        pacients[i].origin = i;
    }

    std::sort(pacients, pacients+n, compare);

    for(int i=0;i<n;++i){
        switch(pacients[i].bt){
        case BloodType::O:
            if(available_O < pacients[i].units_req){
                std::cout << "nemoguce";
                return 0;
            }else{
                result[pacients[i].origin][BloodType::O] = pacients[i].units_req;
                available_O -= pacients[i].units_req;
            }
            break;
        case BloodType::A:
            if((available_O+available_A) < pacients[i].units_req){
                std::cout << "nemoguce";
                return 0;
            }else{
                if(available_A >= pacients[i].units_req){
                    result[pacients[i].origin][BloodType::A] = pacients[i].units_req;
                    available_A -= pacients[i].units_req;
                }else{
                    result[pacients[i].origin][BloodType::A] = available_A;
                    result[pacients[i].origin][BloodType::O] = pacients[i].units_req-available_A;
                    available_O -= pacients[i].units_req-available_A;
                    available_A = 0;
                }
            }
            break;
        case BloodType::B:
            if((available_O+available_B) < pacients[i].units_req){
                std::cout << "nemoguce";
                return 0;
            }else{
                if(available_B >= pacients[i].units_req){
                    result[pacients[i].origin][BloodType::B] = pacients[i].units_req;
                    available_B -= pacients[i].units_req;
                }else{
                    result[pacients[i].origin][BloodType::B] = available_B;
                    result[pacients[i].origin][BloodType::O] = pacients[i].units_req-available_B;
                    available_O -= pacients[i].units_req-available_B;
                    available_B = 0;
                }
            }
            break;
        default:
            if((available_O+available_A+available_B+available_AB) < pacients[i].units_req){
                std::cout << "nemoguce";
                return 0;
            }else{
                if(available_AB >= pacients[i].units_req){
                    result[pacients[i].origin][BloodType::B] = pacients[i].units_req;
                    available_AB -= pacients[i].units_req;
                }else{
                    int colected = 0;
                    result[pacients[i].origin][BloodType::AB] = available_AB;
                    colected+=available_AB;
                    available_AB = 0;
                    if(available_O != 0){
                        result[pacients[i].origin][BloodType::O] = std::min(pacients[i].units_req-colected, available_O);
                        colected += std::min(pacients[i].units_req-colected, available_O);
                        available_O -= std::min(pacients[i].units_req-colected, available_O);
                    }
                    if(available_A != 0 && colected<pacients[i].units_req){
                        result[pacients[i].origin][BloodType::A] = std::min(pacients[i].units_req-colected, available_A);
                        colected += std::min(pacients[i].units_req-colected, available_A);
                        available_A -= std::min(pacients[i].units_req-colected, available_A);
                    }
                    if(available_B != 0 && colected<pacients[i].units_req){
                        result[pacients[i].origin][BloodType::B] = std::min(pacients[i].units_req-colected, available_B);
                        colected += std::min(pacients[i].units_req-colected, available_B);
                        available_B -= std::min(pacients[i].units_req-colected, available_B);
                    }
                }
            }
            break;
        }
    }
    
    std::cout << "nemoguce\n";
    for(int i=0;i<n;++i){
        for(int j=0;j<4;++j){
            std::cout << result[i][j] << " ";
        }
        std::cout << "\n";
    }

    return 0;
}